/*****************************************************************************
*  LPC11U6x 2ch PWM program
*
*   Uses the unified 32-bit timer mode to generate single-edge aligned outputs.
*   An interrupt can be generated after each cycle.
*****************************************************************************/
#include "board.h"

#define match_green_OFF     (5000000)
#define match_green_ON      (4000000)
#define match_red_OFF       (9000000)
#define match_red_ON        (1000000)
#define delay               (10000000)

void SCT1_Init(void);

void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);							   						                  //enable clock for SCT0/1

	Chip_SCT_Config(LPC_SCT1, SCT_CONFIG_32BIT_COUNTER |
                            SCT_CONFIG_AUTOLIMIT_L   );						      //two 16-bit timers, clocked internally, auto limit


	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, delay);						    // match_cycle
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_1, match_green_OFF);			// match_green_OFF
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_2, match_green_ON);				// match_green_ON
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_3, match_red_OFF);				// match_red_OFF
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_4, match_red_ON);				  // match_red_ON


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_STATE0);					// event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0	|			// related to match 0
                                                                        SCT_IOCOND_LOW		  |			// IN_0 low
                                                                        SCT_COMBMODE_AND	  |			// COMBMODE[13:12] = match AND IO condition
                                                                        SCT_STATELD_1		    |			// STATELD[14] = STATEV is loaded into state
                                                                        SCT_STATEEV_1		    ));		// STATEV[15] = 1

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_1, ENABLE_STATE0);					// event 1 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH3	|			// related to match_red_OFF
                                                                        SCT_COMBMODE_MATCH	));		// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_2, ENABLE_STATE0);					// event 2 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_2, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH4	|			// related to match_red_ON
                                                                        SCT_COMBMODE_MATCH	));		// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_3, ENABLE_STATE1);					// event 3 only happens in state 1
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_3, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0	|			// related to match 0
                                                                        SCT_IOCOND_HIGH	    |			// IN_0 high
                                                                        SCT_COMBMODE_AND	  |			// COMBMODE[13:12] = match AND IO condition
                                                                        SCT_STATELD_1		    |			// STATELD[14] = STATEV is loaded into state
                                                                        SCT_STATEEV_0		    ));		// STATEV[15] = 0

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_4, ENABLE_STATE1);					// event 4 only happens in state 1
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_4, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH2	|			// related to match_green_OFF
                                                                        SCT_COMBMODE_MATCH	));		// COMBMODE[13:12] = match condition only

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_5, ENABLE_STATE1);					// event 5 only happens in state 1
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_5, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1	|			// related to match_green_ON
                                                                        SCT_COMBMODE_MATCH	));		// COMBMODE[13:12] = match condition only




	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0 , (CHIP_SCT_EVENT_T)  ( SCT_EVT_0 |						// event 0, 3 and 5 set OUT0 (green LED)
                                                                    SCT_EVT_3 |
                                                                    SCT_EVT_5 ));

	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_4);					// event 4 clear OUT0 (green LED)


	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_1 , (CHIP_SCT_EVENT_T)  ( SCT_EVT_0 |						// event 0, 1 and 3 set OUT1 (red LED)
                                                                    SCT_EVT_1 |
                                                                    SCT_EVT_3 ));

	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_1, SCT_EVT_2);					// event 2 clear OUT1 (red LED)

	LPC_SCT1->OUTPUT    |= 3;                              						// default set OUT0 and OUT1

	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_HALT_L);							// unhalt it by clearing bit 2 of the CTRL register
}




int main (void) 
{

	SystemCoreClockUpdate();
	Board_Init();

	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON


	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,8 , 0x00000081);				// P2_8 is SCT1_IN0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 ,0x00000081);				// P2_16 is SCT1_OUT0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,17 ,0x00000081);				// P2_17  is SCT1_OUT1

    SCT1_Init();                                   					// Initialize SCT


    while (1)                                              			// loop forever
    {
    	__WFI();
    }
}

